<?php
/**
 * ChatReact Admin Page
 *
 * @package ChatReact
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$assignment_count = count( $assignments );
?>
<div class="chatreact-admin-wrap">
<div class="chatreact-admin">
    
    <!-- Notice -->
    <div id="chatreact-notice" class="chatreact-notice">
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"></polyline></svg>
        <span class="chatreact-notice-message"></span>
    </div>

    <!-- Header -->
    <div class="chatreact-header">
        <div class="chatreact-header-left">
            <div class="chatreact-logo-container">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                </svg>
            </div>
            <div>
                <h1 class="chatreact-header-title">ChatReact</h1>
                <p class="chatreact-header-subtitle"><?php esc_html_e( 'AI-Powered Chat Widgets for WordPress', 'chatreact' ); ?></p>
            </div>
        </div>
        <div class="chatreact-header-right">
            <a href="https://www.chatreact.ai/dashboard" target="_blank" class="chatreact-btn chatreact-btn-primary">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"></path><polyline points="15 3 21 3 21 9"></polyline><line x1="10" y1="14" x2="21" y2="3"></line></svg>
                <?php esc_html_e( 'Open Dashboard', 'chatreact' ); ?>
            </a>
            <a href="https://chatreact.ai/docs" target="_blank" class="chatreact-btn chatreact-btn-secondary">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"></path><path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"></path></svg>
                <?php esc_html_e( 'Documentation', 'chatreact' ); ?>
            </a>
        </div>
    </div>

    <!-- Tabs -->
    <div class="chatreact-tabs">
        <button class="chatreact-tab active" data-tab="chat">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
            <?php esc_html_e( 'Chat Widget', 'chatreact' ); ?>
            <span class="chatreact-tab-badge"><?php echo esc_html( $assignment_count ); ?></span>
        </button>
        <button class="chatreact-tab" data-tab="form">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/><polyline points="14 2 14 8 20 8"/><line x1="16" y1="13" x2="8" y2="13"/><line x1="16" y1="17" x2="8" y2="17"/><polyline points="10 9 9 9 8 9"/></svg>
            <?php esc_html_e( 'Forms', 'chatreact' ); ?>
        </button>
        <button class="chatreact-tab" data-tab="faq">
            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
            <?php esc_html_e( 'FAQ Widget', 'chatreact' ); ?>
        </button>
    </div>

    <!-- Tab Content: Chat Widget -->
    <div id="tab-chat" class="chatreact-tab-content active">
        <div class="chatreact-card">
            <div class="chatreact-card-header">
                <div>
                    <h2 class="chatreact-card-title">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
                        <?php esc_html_e( 'Widget Assignments', 'chatreact' ); ?>
                    </h2>
                    <p class="chatreact-card-subtitle"><?php esc_html_e( 'Assign chat widgets to specific pages or posts', 'chatreact' ); ?></p>
                </div>
                <div>
                    <button type="button" id="chatreact-post-types-toggle" class="chatreact-btn chatreact-btn-ghost chatreact-btn-sm" title="<?php esc_attr_e( 'Configure searchable post types', 'chatreact' ); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="3"></circle><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path></svg>
                        <?php esc_html_e( 'Post Types', 'chatreact' ); ?>
                    </button>
                </div>
            </div>
            
            <!-- Post Types Settings Panel -->
            <div id="chatreact-post-types-panel" class="chatreact-post-types-panel" style="display: none;">
                <div class="chatreact-post-types-header">
                    <h3><?php esc_html_e( 'Searchable Post Types', 'chatreact' ); ?></h3>
                    <p><?php esc_html_e( 'Select which post types should be searchable when assigning widgets. Only "Pages" is enabled by default.', 'chatreact' ); ?></p>
                </div>
                <div id="chatreact-post-types-list" class="chatreact-post-types-list">
                    <!-- Post types will be loaded via AJAX -->
                    <div class="chatreact-post-types-loading">
                        <span class="chatreact-spinner"></span>
                        <?php esc_html_e( 'Loading...', 'chatreact' ); ?>
                    </div>
                </div>
                <div class="chatreact-post-types-actions">
                    <button type="button" id="chatreact-save-post-types" class="chatreact-btn chatreact-btn-primary chatreact-btn-sm">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"></polyline></svg>
                        <?php esc_html_e( 'Save', 'chatreact' ); ?>
                    </button>
                    <button type="button" id="chatreact-close-post-types" class="chatreact-btn chatreact-btn-ghost chatreact-btn-sm">
                        <?php esc_html_e( 'Close', 'chatreact' ); ?>
                    </button>
                </div>
            </div>

            <?php if ( $assignment_count > 0 ) : ?>
                <table id="chatreact-assignments-table" class="chatreact-assignments-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'Page / Post', 'chatreact' ); ?></th>
                            <th><?php esc_html_e( 'Chatbot ID', 'chatreact' ); ?></th>
                            <th style="width: 120px;"><?php esc_html_e( 'Actions', 'chatreact' ); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ( $assignments as $id => $assignment ) : 
                            $is_everywhere = empty( $assignment['post_id'] ) || $assignment['post_id'] == 0;
                            $post = null;
                            $post_type_obj = null;
                            
                            if ( ! $is_everywhere ) {
                                $post = get_post( $assignment['post_id'] );
                                if ( ! $post ) continue;
                                $post_type_obj = get_post_type_object( $post->post_type );
                            }
                        ?>
                            <tr data-id="<?php echo esc_attr( $id ); ?>" data-is-everywhere="<?php echo $is_everywhere ? '1' : '0'; ?>">
                                <td>
                                    <div class="chatreact-assignment-page">
                                        <?php if ( $is_everywhere ) : ?>
                                            <div class="chatreact-page-icon chatreact-page-icon-everywhere">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="2" y1="12" x2="22" y2="12"></line><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path></svg>
                                            </div>
                                            <div>
                                                <div class="chatreact-page-title"><?php esc_html_e( 'Everywhere', 'chatreact' ); ?></div>
                                                <div class="chatreact-page-type"><?php esc_html_e( 'All pages', 'chatreact' ); ?></div>
                                                <?php if ( ! empty( $assignment['exclude_urls'] ) ) : ?>
                                                    <div class="chatreact-exclude-info">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="4.93" y1="4.93" x2="19.07" y2="19.07"></line></svg>
                                                        <?php 
                                                        $count = count( array_filter( explode( "\n", $assignment['exclude_urls'] ) ) );
                                                        printf( 
                                                            /* translators: %d: number of excluded URLs */
                                                            _n( '%d URL excluded', '%d URLs excluded', $count, 'chatreact' ), 
                                                            $count 
                                                        ); 
                                                        ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php else : ?>
                                            <div class="chatreact-page-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline></svg>
                                            </div>
                                            <div>
                                                <div class="chatreact-page-title"><?php echo esc_html( $post->post_title ); ?></div>
                                                <div class="chatreact-page-type"><?php echo esc_html( $post_type_obj->labels->singular_name ); ?></div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="chatreact-badge chatreact-badge-purple chatreact-chatbot-id"><?php echo esc_html( $assignment['chatbot_id'] ); ?></span>
                                </td>
                                <td>
                                    <div class="chatreact-actions">
                                        <button type="button" class="chatreact-btn chatreact-btn-ghost chatreact-btn-sm chatreact-edit-assignment" data-id="<?php echo esc_attr( $id ); ?>" data-chatbot-id="<?php echo esc_attr( $assignment['chatbot_id'] ); ?>" data-exclude-urls="<?php echo esc_attr( isset( $assignment['exclude_urls'] ) ? $assignment['exclude_urls'] : '' ); ?>" data-is-everywhere="<?php echo $is_everywhere ? '1' : '0'; ?>" title="<?php esc_attr_e( 'Edit', 'chatreact' ); ?>">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path></svg>
                                        </button>
                                        <button type="button" class="chatreact-btn chatreact-btn-ghost chatreact-btn-sm chatreact-delete-assignment" data-id="<?php echo esc_attr( $id ); ?>" title="<?php esc_attr_e( 'Delete', 'chatreact' ); ?>">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path></svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else : ?>
                <table id="chatreact-assignments-table" class="chatreact-assignments-table" style="display: none;">
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'Page / Post', 'chatreact' ); ?></th>
                            <th><?php esc_html_e( 'Chatbot ID', 'chatreact' ); ?></th>
                            <th style="width: 120px;"><?php esc_html_e( 'Actions', 'chatreact' ); ?></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
                
                <div id="chatreact-empty-state" class="chatreact-empty-state">
                    <div class="chatreact-empty-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
                    </div>
                    <h3 class="chatreact-empty-title"><?php esc_html_e( 'No widgets assigned yet', 'chatreact' ); ?></h3>
                    <p class="chatreact-empty-text"><?php esc_html_e( 'Assign your first chat widget to a page or post using the form below.', 'chatreact' ); ?></p>
                </div>
            <?php endif; ?>

            <!-- Action Buttons -->
            <div class="chatreact-action-bar">
                <button type="button" id="chatreact-add-row-btn" class="chatreact-btn chatreact-btn-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                    <?php esc_html_e( 'Add Assignment', 'chatreact' ); ?>
                </button>
                
                <button type="button" id="chatreact-save-all-btn" class="chatreact-btn chatreact-btn-primary chatreact-btn-save" style="display: none;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path><polyline points="17 21 17 13 7 13 7 21"></polyline><polyline points="7 3 7 8 15 8"></polyline></svg>
                    <?php esc_html_e( 'Save Changes', 'chatreact' ); ?>
                </button>
            </div>
            
            <!-- Hidden template for new row - uses AJAX search for posts -->
            <script type="text/template" id="chatreact-new-row-template">
                <tr class="chatreact-new-row" data-new="true">
                    <td>
                        <div class="chatreact-inline-select-wrapper" data-ajax-search="true">
                            <input type="hidden" class="chatreact-row-post-id" value="">
                            <div class="chatreact-inline-select-trigger" tabindex="0">
                                <span class="placeholder"><?php esc_html_e( 'Select...', 'chatreact' ); ?></span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="6 9 12 15 18 9"></polyline></svg>
                            </div>
                            <div class="chatreact-inline-select-dropdown">
                                <div class="chatreact-inline-select-search">
                                    <input type="text" placeholder="<?php esc_attr_e( 'Type to search pages and posts...', 'chatreact' ); ?>" autocomplete="off">
                                </div>
                                <div class="chatreact-inline-select-options">
                                    <!-- Everywhere Option with Globe Icon -->
                                    <div class="chatreact-inline-select-option chatreact-inline-select-option-everywhere" data-value="0" data-title="<?php esc_attr_e( 'Everywhere', 'chatreact' ); ?>" data-type="<?php esc_attr_e( 'All pages', 'chatreact' ); ?>">
                                        <div class="option-icon option-icon-everywhere">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="2" y1="12" x2="22" y2="12"></line><path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path></svg>
                                        </div>
                                        <div class="option-content">
                                            <div class="option-title"><?php esc_html_e( 'Everywhere', 'chatreact' ); ?></div>
                                            <div class="option-type"><?php esc_html_e( 'All pages', 'chatreact' ); ?></div>
                                        </div>
                                    </div>
                                    
                                    <!-- Divider -->
                                    <div class="chatreact-inline-select-divider"></div>
                                    
                                    <!-- Search results will be loaded here via AJAX -->
                                    <div class="chatreact-inline-select-ajax-results">
                                        <div class="chatreact-inline-select-hint">
                                            <?php esc_html_e( 'Type at least 2 characters to search...', 'chatreact' ); ?>
                                        </div>
                                    </div>
                                    
                                    <!-- Loading indicator -->
                                    <div class="chatreact-inline-select-loading" style="display: none;">
                                        <span class="chatreact-spinner"></span>
                                        <?php esc_html_e( 'Searching...', 'chatreact' ); ?>
                                    </div>
                                    
                                    <!-- No results message -->
                                    <div class="chatreact-inline-select-no-results" style="display: none;">
                                        <?php esc_html_e( 'No results found.', 'chatreact' ); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Exclude URLs field - shown when "Everywhere" is selected -->
                        <div class="chatreact-exclude-urls-wrapper" style="display: none;">
                            <label class="chatreact-exclude-urls-label">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="4.93" y1="4.93" x2="19.07" y2="19.07"></line></svg>
                                <?php esc_html_e( 'Exclude URLs (optional)', 'chatreact' ); ?>
                            </label>
                            <textarea class="chatreact-input chatreact-row-exclude-urls" rows="3" placeholder="<?php esc_attr_e( '/contact&#10;/checkout&#10;/admin/*', 'chatreact' ); ?>"></textarea>
                            <p class="chatreact-exclude-urls-hint"><?php esc_html_e( 'One URL per line. Use * for wildcards (e.g., /blog/*)', 'chatreact' ); ?></p>
                        </div>
                    </td>
                    <td>
                        <input type="text" class="chatreact-input chatreact-row-chatbot-id" placeholder="<?php esc_attr_e( 'Enter Chatbot ID...', 'chatreact' ); ?>">
                    </td>
                    <td>
                        <div class="chatreact-actions">
                            <button type="button" class="chatreact-btn chatreact-btn-ghost chatreact-btn-sm chatreact-remove-new-row" title="<?php esc_attr_e( 'Remove', 'chatreact' ); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                            </button>
                        </div>
                    </td>
                </tr>
            </script>
        </div>

        <!-- Where to find Chatbot ID -->
        <div class="chatreact-card">
            <div class="chatreact-card-header">
                <h2 class="chatreact-card-title">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
                    <?php esc_html_e( 'Where to find your Chatbot ID', 'chatreact' ); ?>
                </h2>
            </div>
            
            <div class="chatreact-steps">
                <div class="chatreact-step">
                    <span class="chatreact-step-number">1</span>
                    <div class="chatreact-step-content">
                        <h4><?php esc_html_e( 'Open your ChatReact Dashboard', 'chatreact' ); ?></h4>
                        <p><?php esc_html_e( 'Go to www.chatreact.ai and log in to your account.', 'chatreact' ); ?></p>
                    </div>
                </div>
                <div class="chatreact-step">
                    <span class="chatreact-step-number">2</span>
                    <div class="chatreact-step-content">
                        <h4><?php esc_html_e( 'Select your Chatbot', 'chatreact' ); ?></h4>
                        <p><?php esc_html_e( 'Navigate to your chatbot and go to Settings.', 'chatreact' ); ?></p>
                    </div>
                </div>
                <div class="chatreact-step">
                    <span class="chatreact-step-number">3</span>
                    <div class="chatreact-step-content">
                        <h4><?php esc_html_e( 'Copy the Chatbot ID', 'chatreact' ); ?></h4>
                        <p><?php esc_html_e( 'Find the Chatbot ID in the Embed section and copy it.', 'chatreact' ); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tab Content: Forms -->
    <div id="tab-form" class="chatreact-tab-content">
        <div class="chatreact-alert chatreact-alert-info">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><line x1="12" y1="16" x2="12" y2="12"/><line x1="12" y1="8" x2="12.01" y2="8"/></svg>
            <div class="chatreact-alert-content">
                <h4 class="chatreact-alert-title"><?php esc_html_e( 'Form Integration', 'chatreact' ); ?></h4>
                <p class="chatreact-alert-text"><?php esc_html_e( 'ChatReact forms are embedded inline using shortcodes or Gutenberg blocks. Unlike the chat widget, forms are placed directly in your page content.', 'chatreact' ); ?></p>
            </div>
        </div>

        <div class="chatreact-card">
            <div class="chatreact-card-header">
                <h2 class="chatreact-card-title">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/><polyline points="14 2 14 8 20 8"/></svg>
                    <?php esc_html_e( 'How to Embed Forms', 'chatreact' ); ?>
                </h2>
            </div>

            <div class="chatreact-doc-grid">
                <div class="chatreact-doc-card">
                    <div class="chatreact-doc-card-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>
                    </div>
                    <h3><?php esc_html_e( 'Shortcode', 'chatreact' ); ?></h3>
                    <p><?php esc_html_e( 'Add this shortcode to any page, post, or widget area:', 'chatreact' ); ?></p>
                    <code class="chatreact-code">[chatreact_form id="YOUR_FORM_ID"]</code>
                </div>

                <div class="chatreact-doc-card">
                    <div class="chatreact-doc-card-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><line x1="3" y1="9" x2="21" y2="9"/><line x1="9" y1="21" x2="9" y2="9"/></svg>
                    </div>
                    <h3><?php esc_html_e( 'Gutenberg Block', 'chatreact' ); ?></h3>
                    <p><?php esc_html_e( 'Search for "ChatReact Form" in the block inserter and configure the Form ID in the sidebar.', 'chatreact' ); ?></p>
                </div>

                <div class="chatreact-doc-card">
                    <div class="chatreact-doc-card-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="12 2 2 7 12 12 22 7 12 2"/><polyline points="2 17 12 22 22 17"/><polyline points="2 12 12 17 22 12"/></svg>
                    </div>
                    <h3><?php esc_html_e( 'Elementor Widget', 'chatreact' ); ?></h3>
                    <p><?php esc_html_e( 'Drag the "ChatReact Form" widget from the ChatReact category in Elementor.', 'chatreact' ); ?></p>
                </div>
            </div>

            <h3 style="margin-top: 32px; font-size: 16px; color: #1e293b;"><?php esc_html_e( 'Example', 'chatreact' ); ?></h3>
            <code class="chatreact-code">[chatreact_form id="form123"]</code>
        </div>

        <!-- Where to find Form ID -->
        <div class="chatreact-card">
            <div class="chatreact-card-header">
                <h2 class="chatreact-card-title">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
                    <?php esc_html_e( 'Where to find your Form ID', 'chatreact' ); ?>
                </h2>
            </div>
            
            <div class="chatreact-steps">
                <div class="chatreact-step">
                    <span class="chatreact-step-number">1</span>
                    <div class="chatreact-step-content">
                        <h4><?php esc_html_e( 'Open your ChatReact Dashboard', 'chatreact' ); ?></h4>
                        <p><?php esc_html_e( 'Go to www.chatreact.ai and log in to your account.', 'chatreact' ); ?></p>
                    </div>
                </div>
                <div class="chatreact-step">
                    <span class="chatreact-step-number">2</span>
                    <div class="chatreact-step-content">
                        <h4><?php esc_html_e( 'Navigate to Forms', 'chatreact' ); ?></h4>
                        <p><?php esc_html_e( 'Click on "Forms" in the sidebar menu.', 'chatreact' ); ?></p>
                    </div>
                </div>
                <div class="chatreact-step">
                    <span class="chatreact-step-number">3</span>
                    <div class="chatreact-step-content">
                        <h4><?php esc_html_e( 'Copy the Form ID', 'chatreact' ); ?></h4>
                        <p><?php esc_html_e( 'Select your form and copy the Form ID from the settings.', 'chatreact' ); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tab Content: FAQ -->
    <div id="tab-faq" class="chatreact-tab-content">
        <div class="chatreact-alert chatreact-alert-info">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><line x1="12" y1="16" x2="12" y2="12"/><line x1="12" y1="8" x2="12.01" y2="8"/></svg>
            <div class="chatreact-alert-content">
                <h4 class="chatreact-alert-title"><?php esc_html_e( 'FAQ Widget', 'chatreact' ); ?></h4>
                <p class="chatreact-alert-text"><?php esc_html_e( 'Display your chatbot\'s FAQs as a beautiful accordion widget. FAQs are automatically synced from your ChatReact dashboard.', 'chatreact' ); ?></p>
            </div>
        </div>

        <div class="chatreact-card">
            <div class="chatreact-card-header">
                <h2 class="chatreact-card-title">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"/><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
                    <?php esc_html_e( 'How to Embed FAQs', 'chatreact' ); ?>
                </h2>
            </div>

            <div class="chatreact-doc-grid">
                <div class="chatreact-doc-card">
                    <div class="chatreact-doc-card-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>
                    </div>
                    <h3><?php esc_html_e( 'Shortcode', 'chatreact' ); ?></h3>
                    <p><?php esc_html_e( 'Add this shortcode to any page, post, or widget area:', 'chatreact' ); ?></p>
                    <code class="chatreact-code">[chatreact_faq id="YOUR_CHATBOT_ID"]</code>
                </div>

                <div class="chatreact-doc-card">
                    <div class="chatreact-doc-card-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><rect x="3" y="3" width="18" height="18" rx="2" ry="2"/><line x1="3" y1="9" x2="21" y2="9"/><line x1="9" y1="21" x2="9" y2="9"/></svg>
                    </div>
                    <h3><?php esc_html_e( 'Gutenberg Block', 'chatreact' ); ?></h3>
                    <p><?php esc_html_e( 'Search for "ChatReact FAQ" in the block inserter and configure the Chatbot ID in the sidebar.', 'chatreact' ); ?></p>
                </div>

                <div class="chatreact-doc-card">
                    <div class="chatreact-doc-card-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="12 2 2 7 12 12 22 7 12 2"/><polyline points="2 17 12 22 22 17"/><polyline points="2 12 12 17 22 12"/></svg>
                    </div>
                    <h3><?php esc_html_e( 'Elementor Widget', 'chatreact' ); ?></h3>
                    <p><?php esc_html_e( 'Drag the "ChatReact FAQ" widget from the ChatReact category in Elementor.', 'chatreact' ); ?></p>
                </div>
            </div>

            <h3 style="margin-top: 32px; font-size: 16px; color: #1e293b;"><?php esc_html_e( 'Optional: Filter by Category', 'chatreact' ); ?></h3>
            <code class="chatreact-code">[chatreact_faq id="abc123" categories="general,pricing"]</code>
        </div>
    </div>

    <!-- Footer -->
    <div class="chatreact-footer">
        <p>
            <?php 
            printf( 
                /* translators: %s: version number */
                esc_html__( 'ChatReact WordPress Plugin v%s', 'chatreact' ), 
                esc_html( CHATREACT_VERSION ) 
            ); 
            ?>
        </p>
    </div>

</div>
</div>

<!-- Delete Confirmation Modal -->
<div id="chatreact-delete-modal" class="chatreact-modal">
    <div class="chatreact-modal-backdrop"></div>
    <div class="chatreact-modal-container">
        <div class="chatreact-modal-content">
            <div class="chatreact-modal-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>
            </div>
            <h3 class="chatreact-modal-title"><?php esc_html_e( 'Delete Assignment', 'chatreact' ); ?></h3>
            <p class="chatreact-modal-message"><?php esc_html_e( 'Are you sure you want to delete this widget assignment? This action cannot be undone.', 'chatreact' ); ?></p>
            <div class="chatreact-modal-actions">
                <button type="button" class="chatreact-btn chatreact-btn-secondary" id="chatreact-modal-cancel">
                    <?php esc_html_e( 'Cancel', 'chatreact' ); ?>
                </button>
                <button type="button" class="chatreact-btn chatreact-btn-danger" id="chatreact-modal-confirm">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path></svg>
                    <?php esc_html_e( 'Delete', 'chatreact' ); ?>
                </button>
            </div>
        </div>
    </div>
</div>
