<?php
/**
 * Plugin Name:       ChatReact
 * Plugin URI:        https://chatreact.ai
 * Description:       Embed AI-powered chat widgets, contact forms, and FAQ accordions on your WordPress site.
 * Version:           1.0.25
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Author:            ChatReact
 * Author URI:        https://chatreact.ai
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       chatreact
 * Domain Path:       /languages
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Plugin constants
define( 'CHATREACT_VERSION', '1.0.25' );
define( 'CHATREACT_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'CHATREACT_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'CHATREACT_API_URL', 'https://www.chatreact.ai' );

// Autoload classes
require_once CHATREACT_PLUGIN_DIR . 'includes/class-chatreact.php';
require_once CHATREACT_PLUGIN_DIR . 'includes/class-shortcodes.php';
require_once CHATREACT_PLUGIN_DIR . 'includes/class-blocks.php';
require_once CHATREACT_PLUGIN_DIR . 'includes/class-meta-boxes.php';
require_once CHATREACT_PLUGIN_DIR . 'elementor/class-elementor.php';
require_once CHATREACT_PLUGIN_DIR . 'admin/class-admin.php';

/**
 * Initialize the plugin
 */
function chatreact_init() {
    // Load text domain for translations
    load_plugin_textdomain( 'chatreact', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
    
    // Initialize main plugin class
    ChatReact::get_instance();
    
    // Initialize admin (always, because we need the get_assignments method for frontend rendering)
    ChatReact_Admin::get_instance();
    
    // Initialize shortcodes
    ChatReact_Shortcodes::get_instance();
    
    // Initialize Gutenberg blocks
    ChatReact_Blocks::get_instance();
    
    // Initialize Elementor integration
    ChatReact_Elementor::get_instance();
    
    // Initialize Meta Boxes
    ChatReact_Meta_Boxes::get_instance();
    
    // Register frontend widget rendering hook
    add_action( 'wp_footer', 'chatreact_render_assigned_widgets' );
}
add_action( 'plugins_loaded', 'chatreact_init' );

/**
 * Render assigned widgets on frontend
 * This is called via wp_footer hook
 */
function chatreact_render_assigned_widgets() {
    if ( is_admin() ) {
        return;
    }
    
    $admin = ChatReact_Admin::get_instance();
    $admin->render_assigned_widgets();
}

/**
 * Activation hook
 */
function chatreact_activate() {
    // Nothing to do on activation for now
    flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'chatreact_activate' );

/**
 * Deactivation hook
 */
function chatreact_deactivate() {
    flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'chatreact_deactivate' );
