<?php
/**
 * ChatReact Elementor Integration
 *
 * @package ChatReact
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * ChatReact Elementor class
 */
class ChatReact_Elementor {

    /**
     * Single instance of the class
     *
     * @var ChatReact_Elementor|null
     */
    private static $instance = null;

    /**
     * Minimum Elementor Version
     *
     * @var string
     */
    const MINIMUM_ELEMENTOR_VERSION = '3.0.0';

    /**
     * Get single instance of the class
     *
     * @return ChatReact_Elementor
     */
    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
    private function __construct() {
        // Check if Elementor is installed and activated
        if ( ! did_action( 'elementor/loaded' ) ) {
            return;
        }

        // Check Elementor version
        if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
            return;
        }

        // Register widgets
        add_action( 'elementor/widgets/register', array( $this, 'register_widgets' ) );

        // Register widget category
        add_action( 'elementor/elements/categories_registered', array( $this, 'register_category' ) );
    }

    /**
     * Register widget category
     *
     * @param \Elementor\Elements_Manager $elements_manager Elementor elements manager
     */
    public function register_category( $elements_manager ) {
        $elements_manager->add_category(
            'chatreact',
            array(
                'title' => __( 'ChatReact', 'chatreact' ),
                'icon'  => 'eicon-commenting-o',
            )
        );
    }

    /**
     * Register widgets
     *
     * @param \Elementor\Widgets_Manager $widgets_manager Elementor widgets manager
     */
    public function register_widgets( $widgets_manager ) {
        // Include widget files
        require_once CHATREACT_PLUGIN_DIR . 'elementor/widgets/class-chat-widget.php';
        require_once CHATREACT_PLUGIN_DIR . 'elementor/widgets/class-form-widget.php';
        require_once CHATREACT_PLUGIN_DIR . 'elementor/widgets/class-faq-widget.php';

        // Register widgets
        $widgets_manager->register( new ChatReact_Elementor_Chat_Widget() );
        $widgets_manager->register( new ChatReact_Elementor_Form_Widget() );
        $widgets_manager->register( new ChatReact_Elementor_FAQ_Widget() );
    }
}
