<?php
/**
 * ChatReact Elementor Chat Widget
 *
 * @package ChatReact
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * ChatReact Elementor Chat Widget class
 */
class ChatReact_Elementor_Chat_Widget extends \Elementor\Widget_Base {

    /**
     * Get widget name
     *
     * @return string
     */
    public function get_name() {
        return 'chatreact_chat';
    }

    /**
     * Get widget title
     *
     * @return string
     */
    public function get_title() {
        return __( 'ChatReact Chat', 'chatreact' );
    }

    /**
     * Get widget icon
     *
     * @return string
     */
    public function get_icon() {
        return 'eicon-commenting-o';
    }

    /**
     * Get widget categories
     *
     * @return array
     */
    public function get_categories() {
        return array( 'chatreact', 'general' );
    }

    /**
     * Get widget keywords
     *
     * @return array
     */
    public function get_keywords() {
        return array( 'chat', 'chatbot', 'ai', 'support', 'chatreact' );
    }

    /**
     * Register widget controls
     */
    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __( 'Chat Widget Settings', 'chatreact' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'chatbot_id',
            array(
                'label'       => __( 'Chatbot ID', 'chatreact' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your Chatbot ID', 'chatreact' ),
                'description' => __( 'Required. Find this in your ChatReact dashboard. All widget settings (position, colors, etc.) are configured in your ChatReact dashboard.', 'chatreact' ),
            )
        );

        $this->end_controls_section();
    }

    /**
     * Render widget output on the frontend
     */
    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( empty( $settings['chatbot_id'] ) ) {
            if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                echo '<div class="chatreact-elementor-placeholder">';
                echo '<p>' . esc_html__( 'Please enter a Chatbot ID in the widget settings.', 'chatreact' ) . '</p>';
                echo '</div>';
            }
            return;
        }

        echo ChatReact::render_chat_widget( $settings['chatbot_id'] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

    /**
     * Render widget output in the editor
     */
    protected function content_template() {
        ?>
        <#
        if ( ! settings.chatbot_id ) {
        #>
            <div class="chatreact-elementor-placeholder">
                <p><?php esc_html_e( 'Please enter a Chatbot ID in the widget settings.', 'chatreact' ); ?></p>
            </div>
        <#
        } else {
        #>
            <div class="chatreact-elementor-preview">
                <div class="chatreact-elementor-icon">💬</div>
                <div class="chatreact-elementor-content">
                    <strong><?php esc_html_e( 'ChatReact Chat Widget', 'chatreact' ); ?></strong>
                    <span>ID: {{{ settings.chatbot_id }}}</span>
                </div>
            </div>
        <#
        }
        #>
        <?php
    }
}
