<?php
/**
 * ChatReact Elementor FAQ Widget
 *
 * @package ChatReact
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * ChatReact Elementor FAQ Widget class
 */
class ChatReact_Elementor_FAQ_Widget extends \Elementor\Widget_Base {

    /**
     * Get widget name
     *
     * @return string
     */
    public function get_name() {
        return 'chatreact_faq';
    }

    /**
     * Get widget title
     *
     * @return string
     */
    public function get_title() {
        return __( 'ChatReact FAQ', 'chatreact' );
    }

    /**
     * Get widget icon
     *
     * @return string
     */
    public function get_icon() {
        return 'eicon-help-o';
    }

    /**
     * Get widget categories
     *
     * @return array
     */
    public function get_categories() {
        return array( 'chatreact', 'general' );
    }

    /**
     * Get widget keywords
     *
     * @return array
     */
    public function get_keywords() {
        return array( 'faq', 'accordion', 'questions', 'chatreact' );
    }

    /**
     * Register widget controls
     */
    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __( 'FAQ Widget Settings', 'chatreact' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'chatbot_id',
            array(
                'label'       => __( 'Chatbot ID', 'chatreact' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your Chatbot ID', 'chatreact' ),
                'description' => __( 'Required. Find this in your ChatReact dashboard.', 'chatreact' ),
            )
        );

        $this->add_control(
            'categories',
            array(
                'label'       => __( 'Categories', 'chatreact' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'e.g., general,pricing', 'chatreact' ),
                'description' => __( 'Comma-separated category slugs to filter FAQs.', 'chatreact' ),
            )
        );

        $this->add_control(
            'language',
            array(
                'label'       => __( 'Language', 'chatreact' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'e.g., de, fr', 'chatreact' ),
                'description' => __( 'Leave empty for auto-detect.', 'chatreact' ),
            )
        );

        $this->end_controls_section();
    }

    /**
     * Render widget output on the frontend
     */
    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( empty( $settings['chatbot_id'] ) ) {
            if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                echo '<div class="chatreact-elementor-placeholder">';
                echo '<p>' . esc_html__( 'Please enter a Chatbot ID in the widget settings.', 'chatreact' ) . '</p>';
                echo '</div>';
            }
            return;
        }

        echo ChatReact::render_faq_widget( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            $settings['chatbot_id'],
            array(
                'categories' => $settings['categories'],
                'language'   => $settings['language'],
            )
        );
    }

    /**
     * Render widget output in the editor
     */
    protected function content_template() {
        ?>
        <#
        if ( ! settings.chatbot_id ) {
        #>
            <div class="chatreact-elementor-placeholder">
                <p><?php esc_html_e( 'Please enter a Chatbot ID in the widget settings.', 'chatreact' ); ?></p>
            </div>
        <#
        } else {
        #>
            <div class="chatreact-elementor-preview chatreact-faq-preview">
                <div class="chatreact-elementor-icon">❓</div>
                <div class="chatreact-elementor-content">
                    <strong><?php esc_html_e( 'ChatReact FAQ Accordion', 'chatreact' ); ?></strong>
                    <span>ID: {{{ settings.chatbot_id }}}</span>
                    <# if ( settings.categories ) { #>
                        <span class="categories"><?php esc_html_e( 'Categories:', 'chatreact' ); ?> {{{ settings.categories }}}</span>
                    <# } #>
                </div>
            </div>
        <#
        }
        #>
        <?php
    }
}
