<?php
/**
 * ChatReact Elementor Form Widget
 *
 * @package ChatReact
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * ChatReact Elementor Form Widget class
 */
class ChatReact_Elementor_Form_Widget extends \Elementor\Widget_Base {

    /**
     * Get widget name
     *
     * @return string
     */
    public function get_name() {
        return 'chatreact_form';
    }

    /**
     * Get widget title
     *
     * @return string
     */
    public function get_title() {
        return __( 'ChatReact Form', 'chatreact' );
    }

    /**
     * Get widget icon
     *
     * @return string
     */
    public function get_icon() {
        return 'eicon-form-horizontal';
    }

    /**
     * Get widget categories
     *
     * @return array
     */
    public function get_categories() {
        return array( 'chatreact', 'general' );
    }

    /**
     * Get widget keywords
     *
     * @return array
     */
    public function get_keywords() {
        return array( 'form', 'contact', 'chatreact' );
    }

    /**
     * Register widget controls
     */
    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            array(
                'label' => __( 'Form Widget Settings', 'chatreact' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            )
        );

        $this->add_control(
            'form_id',
            array(
                'label'       => __( 'Form ID', 'chatreact' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your Form ID', 'chatreact' ),
                'description' => __( 'Required. Find this in your ChatReact dashboard under Forms.', 'chatreact' ),
            )
        );

        $this->add_control(
            'language',
            array(
                'label'       => __( 'Language', 'chatreact' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'e.g., de, fr', 'chatreact' ),
                'description' => __( 'Leave empty for auto-detect.', 'chatreact' ),
            )
        );

        $this->end_controls_section();
    }

    /**
     * Render widget output on the frontend
     */
    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( empty( $settings['form_id'] ) ) {
            if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                echo '<div class="chatreact-elementor-placeholder">';
                echo '<p>' . esc_html__( 'Please enter a Form ID in the widget settings.', 'chatreact' ) . '</p>';
                echo '</div>';
            }
            return;
        }

        echo ChatReact::render_form_widget( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            $settings['form_id'],
            array(
                'language' => $settings['language'],
            )
        );
    }

    /**
     * Render widget output in the editor
     */
    protected function content_template() {
        ?>
        <#
        if ( ! settings.form_id ) {
        #>
            <div class="chatreact-elementor-placeholder">
                <p><?php esc_html_e( 'Please enter a Form ID in the widget settings.', 'chatreact' ); ?></p>
            </div>
        <#
        } else {
        #>
            <div class="chatreact-elementor-preview chatreact-form-preview">
                <div class="chatreact-elementor-icon">📝</div>
                <div class="chatreact-elementor-content">
                    <strong><?php esc_html_e( 'ChatReact Contact Form', 'chatreact' ); ?></strong>
                    <span>ID: {{{ settings.form_id }}}</span>
                </div>
            </div>
        <#
        }
        #>
        <?php
    }
}
